/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_270;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_6025;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class TamableNaturalistAnimal
extends NaturalistAnimal
implements class_6025 {
    protected static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(TamableNaturalistAnimal.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Optional<UUID>> DATA_OWNERUUID_ID = class_2945.method_12791(TamableNaturalistAnimal.class, (class_2941)class_2943.field_13313);
    private boolean orderedToSit;

    protected TamableNaturalistAnimal(class_1299<? extends TamableNaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.reassessTameGoals();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.method_6139() != null) {
            compound.method_25927("Owner", this.method_6139());
        }
        compound.method_10556("Sitting", this.orderedToSit);
    }

    public void method_5749(class_2487 compound) {
        UUID uUID;
        super.method_5749(compound);
        if (compound.method_25928("Owner")) {
            uUID = compound.method_25926("Owner");
        } else {
            String string = compound.method_10558("Owner");
            uUID = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (uUID != null) {
            try {
                this.setOwnerUUID(uUID);
                this.setTame(true);
            }
            catch (Throwable var4) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compound.method_10577("Sitting");
        this.setInSittingPose(this.orderedToSit);
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_5934();
    }

    protected void spawnTamingParticles(boolean tamed) {
        class_2400 particleOptions = class_2398.field_11201;
        if (!tamed) {
            particleOptions = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleOptions, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    public void method_5711(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.method_5711(id);
        }
    }

    public boolean isTame() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean tamed) {
        byte b = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        if (tamed) {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(b | 4)));
        } else {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    public boolean isInSittingPose() {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean sitting) {
        byte b = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        if (sitting) {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(b | 1)));
        } else {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    @Nullable
    public UUID method_6139() {
        return ((Optional)this.field_6011.method_12789(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public void tame(class_1657 player) {
        this.setTame(true);
        this.setOwnerUUID(player.method_5667());
        if (player instanceof class_3222) {
            class_174.field_1201.method_9132((class_3222)player, (class_1429)this);
        }
    }

    public boolean method_18395(class_1309 target) {
        return this.isOwnedBy(target) ? false : super.method_18395(target);
    }

    public boolean isOwnedBy(class_1309 entity) {
        return entity == this.method_35057();
    }

    public boolean wantsToAttack(class_1309 target, class_1309 owner) {
        return true;
    }

    public class_270 method_5781() {
        class_1309 livingEntity;
        if (this.isTame() && (livingEntity = this.method_35057()) != null) {
            return livingEntity.method_5781();
        }
        return super.method_5781();
    }

    public boolean method_5722(class_1297 entity) {
        if (this.isTame()) {
            class_1309 livingEntity = this.method_35057();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.method_5722(entity);
            }
        }
        return super.method_5722(entity);
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.method_35057() instanceof class_3222) {
            this.method_35057().method_43496(this.method_6066().method_5548());
        }
        super.method_6078(damageSource);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean orderedToSit) {
        this.orderedToSit = orderedToSit;
    }
}

